# Saving the random seed

You can save the random seed generated by the system entropy source by setting the random seed to zero first.  This allows the random seed to be recorded.  The following is a simple example of how to do this.

## save_randomseed.glm

~~~
  #ifexist randomseed.glm
    // restore the randomseed prior to initialization
    #include "randomseed.glm"
  #else
    // save randomized value during initialization
    #set randomseed=0
    // allows seed to be visible from script
    script export randomseed;
    // script to save seed on init
    script on_init save_randomseed;
  #endif
  clock {
    starttime "2010-01-01 00:00:00";
    stoptime "2010-01-01 01:00:00";
  }
  class test {
    randomvar value;
  }
  object test {
    value "type: normal(0,1); refresh: 10min";
  }
~~~

## save_randomseed

~~~
  echo "#set randomseed=${randomseed:-0}" > randomseed.glm
~~~
